### **Overview of RADIUS**

- **Purpose**: Originally developed to provide Authentication, Authorization, and Accounting (AAA) for dial-up user services and Remote Access Servers (RAS).
- **Expanded Role**: Now supports AAA needs for a variety of devices and network environments.
- **Key RFCs for Cisco Secure Network Access**:
    - **RFC 2865**: RADIUS
    - **RFC 3579**: RADIUS Support for EAP
    - **RFC 3580**: IEEE 802.1X RADIUS Usage Guidelines

---

### **RADIUS Packet Types**

Used for authenticating and authorizing user communications in 802.1X:

|**Packet Type**|**Description**|
|---|---|
|**Access-Request**|Starts every RADIUS session. Includes user credentials and NAS information. Sent to the RADIUS server.|
|**Access-Accept**|Sent by the RADIUS server to the NAS with configuration details (e.g., VLAN assignment, DACL).|
|**Access-Reject**|Sent by the RADIUS server to the NAS if attributes are invalid or authentication fails.|
|**Access-Challenge**|Sent by the RADIUS server to request additional input, such as a response to a challenge.|

---

### **RADIUS in 802.1X**

- **Transport Mechanism**:
    - RADIUS transports EAP messages between the authenticator (switch or access point) and the authentication server.
    - **EAPOL (Layer 2)**: Used for communication between the supplicant and the authenticator.
    - **Encapsulation in RADIUS (Layer 3)**: Authenticator encapsulates EAP messages into RADIUS for communication with the authentication server.
- **Defined in RFC 3579**: Specifies how EAP is encapsulated in RADIUS packets.
- **Authentication Process**:
    - Authentication starts when the link state changes (down to up) or is initiated by the supplicant through an EAPOL-Start frame.
    - The authenticator sends an EAP request for identity, and the supplicant responds with an EAP response.
    - Authenticator relays EAP frames between the supplicant and the authentication server.
    - Upon successful authentication, the authenticator authorizes the port.

---

### **RADIUS Attributes and Their Role in 802.1X**

- **Attributes Overview**:
    - RADIUS attributes are used to pass information between the client, authenticator, and server.
    - **Attribute-Value Pairs (AVPs)**: Type, Length, and Value (TLV) tuples where the value is variable in size.
    - **Standard Attributes**: Defined by IETF, with a fixed set of 255 attributes.

|**No.**|**Attribute**|**Function**|
|---|---|---|
|1|**User-Name**|Name of the user to authenticate.|
|2|**User-Password**|User's password.|
|4|**NAS-IP-Address**|IP of the NAS requesting authentication.|
|5|**NAS-Port**|Physical port on NAS (e.g., gi1/0/11).|
|8|**Framed-IP-Address**|Specifies IP provided by user or RADIUS.|
|26|**Vendor-Specific**|Attributes defined by vendors (e.g., Cisco, Microsoft, Juniper).|
|30|**Called-Station-Id**|Stores authenticator MAC address.|
|31|**Calling-Station-Id**|Stores supplicant MAC address.|
|32|**NAS Identifier**|Identifies NAS requesting authentication.|
|44|**Acct-Session-Id**|Unique identifier for a user session.|
|64|**Tunnel-Type**|Specifies encapsulation type.|
|65|**Tunnel-Medium-Type**|Specifies the physical medium type.|
|81|**Tunnel-Private-Group-ID**|Specifies VLAN group ID for a session.|

- **Vendor-Specific Attributes (VSAs)**:
    - Defined by attribute 26. Allows vendors to extend RADIUS functionality.
    - Example: **Cisco VSA (cisco-av-pair)**: Used for features such as URL redirection in web authentication.

---

### **Policy Enforcement Using RADIUS Attributes**

- **Policy Decision Point (PDP)**:
    - The RADIUS server evaluates received attributes and enforces policy decisions.
    - Attributes such as **64 (Tunnel-Type)**, **65 (Tunnel-Medium-Type)**, and **81 (Tunnel-Private-Group-ID)** are used for VLAN assignments in 802.1X.
- **Example**:
    - A user authenticates successfully. Based on group membership, the RADIUS server assigns the user to the appropriate VLAN by sending attributes to the authenticator.
    - The authenticator enforces the policy as dictated by the RADIUS server.

---

### **Key Takeaways**

- **Role of RADIUS in 802.1X**: Acts as a bridge between the supplicant, authenticator, and authentication server to transport EAP messages and enforce AAA policies.
- **Packet Types**: Four key RADIUS packets (Access-Request, Access-Accept, Access-Reject, Access-Challenge) facilitate authentication and authorization.
- **Attributes**: RADIUS attributes (standard and vendor-specific) enable policy decisions and communication between devices.
- **Policy Enforcement**: The RADIUS server acts as the Policy Decision Point (PDP), defining access control policies through attributes like VLAN assignments.
- **Encapsulation**: EAP messages are encapsulated in RADIUS packets for secure communication between Layer 2 (EAPOL) and Layer 3 (RADIUS).